/***************************************************************************
								  sprint.h	 
							 -------------------
	Description 		   Header Filer of Printing Utility
 ***************************************************************************/
/***************************************************************************
 *																		   *
 *	 This program is free software; you can redistribute it and/or modify  *
 *	 it under the terms of the GNU General Public License as published by  *
 *	 the Free Software Foundation; either version 2 of the License, or	   *
 *	 (at your option) any later version.								   *
 *																		   *
 ***************************************************************************/


#ifndef _GTAB_SPRINT_H
#define _GTAB_SPRINT_H

typedef struct {
	int 	m_lth;
	char	*m_P;
	int m_size;
} sprintT;

void sprint_init(sprintT *targetP);
void sprint_free(sprintT *targetP);
void print(sprintT *targetP, const char *fmtP, ...);

void printS(sprintT *targetP, Lptr Sc);

/**
@short Prints the PD
Prints the PD data
@param Pointer to PD that has to be printed.
*/

void printPD(sprintT *targetP, Lptr pd) ;

/**
@short Prints "every thing" in the CGUData.
Prints all the Global Dependencies, Partial databases etc.
*/


void printEveryThing(sprintT *targetP);

void initsprint(void);

#endif
