/***************************************************************************
								  optimizer.c	
							 -------------------
	Description 		  C file for Conjunctive Query Optimizer (CQO)
  ***************************************************************************/
/***************************************************************************
 *																		   *
 *	 This program is free software; you can redistribute it and/or modify  *
 *	 it under the terms of the GNU General Public License as published by  *
 *	 the Free Software Foundation; either version 2 of the License, or	   *
 *	 (at your option) any later version.								   *
 *																		   *
 ***************************************************************************/
#include "config.h"

#include <stdio.h>

#include "memmgr.h"
#include "tlisp.h"
#include "pattern.h"
#include "cgu.h"

/********NEGATION NORMAL FORM FUNCTIONS*********/
Lptr NNFRuleControl = NULL;
// CHECK IF (exists R A) is considered in NNF or not.

boolean negationNormalForm(Lptr Form) {
	char *rwRulesNNF =
		"((DoubleNeg (not (not > P)) (<< P))"
		" (NegComparison (not (>or (EQ LT LE GT GE NE) Comp > T1 > T2)) (< NewComp < T1 < T2)"
		"                (bindq NewComp (cadr (assq < Comp ( (EQ NE) (LT GE) (LE GT) (GT LE) (GE LT) (NE EQ))))))"
		" (DeMorgan (not (>or (and or) Opr > T1 > T2)) (< NewOpr (not < T1) (not < T2))"
		"                (bindq NewOpr (cadr (assq < Opr ( (and or) (or and) )))))"
		" (NegQuantifier (not (>or (forallr existsr) Quant > R1 > D1)) (< NewQuant < R1 (not < D1))"
		"                (bindq NewQuant (cadr (assq < Quant ( (forallr existsr) (existsr forallr) )))))"
		" (NNF (not (atomic > P)) (not(atomic < P)))"
		" (NF  (atomic > P) (atomic < P))"
		")";

	char *controlProgNNF =
		"(negNForm "
		"         (or (or NF NNF)"
		"             (if (not (not > P))"
		"                 (and DoubleNeg (env eval (call negNForm))))"
		"             (if (not (>or (and or) Opr > T1 > T2))"
		"                 (and DeMorgan (env cadr (call negNForm)) (env caddr (call negNForm))))"
		"             (if (not (>or (forallr existsr) Quant > R1 > D1))"
		"                 (and NegQuantifier (env caddr (call negNForm))))"
		"             (if (>or (and or) Opr > T1 > T2)"
		"                 (and (env cadr (call negNForm)) (env caddr (call negNForm))))"
		"             (if (>or (forallr existsr) Quant > R1 > D1)"
		"                 (env caddr (call negNForm)))))";	  
	boolean success;

	if (NNFRuleControl == NULL)
		NNFRuleControl = initControl(rwRulesNNF, controlProgNNF);
	success = ApplyRuleControl(getprop(car(car(cdr(NNFRuleControl))),mkstringatom("RuleControl")),Form);
	return (success);
}

void finalizeNNFControl(void) {
	NNFRuleControl = finalizeControl(NNFRuleControl);
}


/********Canonical Query Query*********/
Lptr CannonicalRuleControl = NULL;


boolean QueryCannonicalForm(Lptr Query) {
	char *rwRulesQCF = "("
		" (setframe  (>* Q) (select << attrList (from < NewQ (elim (select (from (from)))))) (bindq NewQ (enforceNewQ < Q)) (bindq attrList (getAttributesList < NewQ)))"
		" (rmselect  (select >* attrList (from >* CasA1 (select * > Q) >* RestQ))"
		"            (select << attrList (from << CasA1 < Q << RestQ)))"
		" (distfrom  (select >* attrList (from >* CasA1 (from >* QList) >* RestQ))"
		"            (select << attrList (from << CasA1 << QList << RestQ)))"
		" (pushequl  (select >* attrList (from >* CasA1 (equal >* APpairs) >* CasA2 (elim (select >* attLElim (from >* CasA3 (from >* EQLR))))))"
		"            (select << attrList (from << CasA1 << CasA2 (elim (select << NwAtElim (from << CasA3 (from << EQLR (equal << APpairs)))))))"
		"            (bindq equalAttr (getAttributesList (equal << APpairs)))(bindq NwAtElim (listUnion < attLElim < equalAttr)))"
		" (pushelim  (select >* attrList (from >* CasA1 (elim > Q) >* CasA2 (elim (select >* attLElim (from >* CasA3 (from >* EQLR))))))"
		"            (select << attrList (from << CasA1 << CasA2 (elim (select << NwAtElim (from << CasA3 < Q (from << EQLR ))))))"
		"            (bindq elimAttr (getAttributesList < Q))(bindq NwAtElim (listUnion < attLElim < elimAttr)))"
		" (elrmsele  (select >* attrList (from >* CasA (elim (select >* attElim (from >* elCasA1 (select * > Q) >* RestQ)))))"
		"            (select << attrList (from << CasA (elim (select << attElim (from << elCasA1 < Q << RestQ))))))"
		" (eldsfrom  (select >* attrList (from >* CasA (elim (select >* attElim (from >* elCasA1 (from >* QList) >* elCasA2 (from >* EQLR))))))"
		"            (select << attrList (from << CasA (elim (select << attElim (from << elCasA1 << QList << elCasA2 (from << EQLR)))))))"
		" (elpsheql  (select >* attrList (from >* CasA (elim (select >* attElim (from >* elCasA1 (equal >* APpairs) >* elCasA2 (from >* EQLR))))))"
		"            (select << attrList (from << CasA (elim (select << attElim (from << elCasA1 << elCasA2 (from << EQLR (equal << APpairs))))))))"
		" (eldselim  (select >* attrList (from >* CasA (elim (select >* attElim (from >* elCasA1 (elim > Q) >* elCasA2 (from >* EQLR))))))"
		"            (select << attrList (from << CasA (elim (select << attElim (from << elCasA1  < Q << elCasA2 (from << EQLR)))))))"
		" (uniqueqs  (select >* attrList (from >* CasA (elim (select >* attElim (from >* elCasA  (from >* EQLR))))))"
		"            (select << attrList (from << DisCasA (elim (select << attElim (from << DselCasA  (from << DisEQLR))))))"
		"            (bindq DisCasA (distinctL < CasA)) (bindq DselCasA (distinctL < elCasA)) (bindq DisEQLR (distinctL < EQLR)))"
		")";

	char *controlProgQCF =
		"(CannonicalForm "
		"          (seq setframe"
		"               (rep (seq rmselect distfrom pushequl pushelim))"
		"               (rep (seq elrmsele eldsfrom elpsheql eldselim))"
		"               uniqueqs"
		"           )"
		")";
	boolean success;

	if (CannonicalRuleControl == NULL)
		CannonicalRuleControl = initControl(rwRulesQCF, controlProgQCF);
	success = ApplyRuleControl(getprop(car(car(cdr(CannonicalRuleControl))),mkstringatom("RuleControl")),Query);
	return (success);
}

void finalizeQCFControl(void) {
	CannonicalRuleControl = finalizeControl(CannonicalRuleControl);
}

Lptr getAttributesList(Lptr Query) {
	Lptr Qword;
	Lptr tmpAttrL, lastTmp, lastAttr;
	Lptr tmpQ, AttrListHead, temp;

	if (!getAtomStrStore(car(Query), &Qword)) {
		return(0);
	}
	if (stringcmp(Qword,"as") == 0) // C as A
		return (cons(car(cdr(cdr(Query))), getNil()));
	else if (stringcmp(Qword,"elim") == 0) // elim Q
		return (getAttributesList(car(cdr(Query))));
	else if (stringcmp(Qword,"equal") == 0) // A.Pf1 = B.Pf2
		return (cons(car(cdr(Query)), cons(car(cdr(cdr(cdr(Query)))), getNil())));
	else if (stringcmp(Qword,"from") == 0) {// from Q1, ..., Qk
		AttrListHead = assign(cons(getNil(), getNil()));
		for(tmpQ = cdr(Query); !vNull(tmpQ); tmpQ = cdr(tmpQ)) {
			tmpAttrL = assign(getAttributesList(car(tmpQ)));
			for (temp = tmpAttrL; !vNull(temp); temp= cdr(temp))
				insertSortList(AttrListHead, car(temp));
			release(tmpAttrL);
		}
		temp = AttrListHead;
		AttrListHead = assign(cdr(AttrListHead));
		release (temp);
		return (decrement(AttrListHead));
	}
	else if (stringcmp(Qword,"select") == 0) {// select A1, ..., An Q
		if (vNull(cdr(cdr(Query))))
			return(getNil());
		else {
			lastAttr = cdr(Query);
			lastTmp = cons(car(lastAttr), getNil());
			tmpAttrL = assign(lastTmp);
			for (lastAttr = cdr(lastAttr);!vNull(cdr(lastAttr)); lastTmp = cdr(lastTmp), lastAttr=cdr(lastAttr))
				rplacd(lastTmp,cons(car(lastAttr), getNil()));
			return(decrement(tmpAttrL));
		}	 
	}
	return(0);
}


Lptr enforceUniqueAttrName(Lptr Query, Lptr AttrSeenHead, Lptr AttrSelect) {
	Lptr Qword;
	Lptr tmpAttrL, lastTmp, lastAttr;
	Lptr tmpQ;
	
	if (getAtomStrStore(car(Query), &Qword)) {
		
		if (stringcmp(Qword,"as") == 0) { // C as A
			if (vNull(AttrSelect)) {//if no previous select ...
				insertSortList(AttrSeenHead, car(cdr(cdr(Query)))); //Add A to seen-so-far List
			}
			else if (vNull(findListHead(AttrSelect,car(cdr(cdr(Query)))))) { //if A not in Select List
				if (!vNull(findListHead(cdr(AttrSeenHead),car(cdr(cdr(Query)))))) {// if A is in seen-so-far List
					rplaca(cdr(cdr(Query)),gensym("ATRNM")); // Rename A to ATRNM'X' where X is a number
				}
				insertSortList(AttrSeenHead, car(cdr(cdr(Query)))); //Add A to seen-so-far List
			} 
		}
		else if (stringcmp(Qword,"elim") == 0) { // elim Q
			enforceUniqueAttrName(car(cdr(Query)), AttrSeenHead, AttrSelect);	 
		}
		else if (stringcmp(Qword,"equal") == 0) { // A.Pf1 = B.Pf2
			if (vNull(AttrSelect)) {//if no previous select ...
				insertSortList(AttrSeenHead, car(cdr(Query))); //Add A to seen-so-far List
				insertSortList(AttrSeenHead, car(cdr(cdr(cdr(Query))))); //Add B to seen-so-far List			
			}
			else {
				if (vNull(findListHead(AttrSelect,car(cdr(Query))))) { //if A not in Select List
					if (!vNull(findListHead(cdr(AttrSeenHead),car(cdr(Query))))) {// if A is in seen-so-far List
						rplaca(cdr(Query),gensym("ATRNM")); // Rename A to ATRNM'X' where X is a number
					}
					insertSortList(AttrSeenHead, car(cdr(Query))); //Add A to seen-so-far List
				}

				if (vNull(findListHead(AttrSelect,car(cdr(cdr(cdr(Query))))))) { //if B not in Select List
					if (!vNull(findListHead(cdr(AttrSeenHead),car(cdr(cdr(cdr(Query))))))) {// if B is in seen-so-far List
						rplaca(cdr(cdr(cdr(Query))),gensym("ATRNM")); // Rename B to ATRNM'X' where X is a number
					}
					insertSortList(AttrSeenHead, car(cdr(cdr(cdr(Query))))); //Add B to seen-so-far List
				}
			}	   
		}
		else if (stringcmp(Qword,"from") == 0) { // from Q1, ..., Qk
			for(tmpQ = cdr(Query); !vNull(tmpQ); tmpQ = cdr(tmpQ)) {
				enforceUniqueAttrName(car(tmpQ), AttrSeenHead, AttrSelect);
			}	 
		}
		else if (stringcmp(Qword,"select") == 0) { // select A1, ..., An Q
			if (vNull(cdr(cdr(Query)))){
				tmpAttrL = assign(cons(getNil(), getNil())); // Note that no attributes is not the same as no select.
				enforceUniqueAttrName(car(cdr(Query)), AttrSeenHead, tmpAttrL); 
				release(tmpAttrL);
			}
			else {
				lastAttr = cdr(Query);
				lastTmp = cons(car(lastAttr), getNil());
				tmpAttrL = assign(lastTmp);
				for (lastAttr = cdr(lastAttr);!vNull(cdr(lastAttr)); lastTmp = cdr(lastTmp), lastAttr=cdr(lastAttr)) {
					rplacd(lastTmp,cons(car(lastAttr), getNil()));
					insertSortList(AttrSeenHead,car(lastAttr));
				}
				enforceUniqueAttrName(car(lastAttr), AttrSeenHead, tmpAttrL);
				release(tmpAttrL);
			}
		}
	}
	return (Query);
}

Lptr enforceNewQ (Lptr Query) {
	Lptr ALHead, NewQ;

	ALHead = assign(cons(getNil(),getNil()));
	NewQ = enforceUniqueAttrName(Query,ALHead,getNil());
	release(ALHead);
	return(NewQ);
}

Lptr distinctL(Lptr L1) {
	Lptr UListHead, temp;

	UListHead = assign(cons(getNil(), getNil()));
	for (temp = L1; !vNull(temp); temp= cdr(temp))
		insertSortList(UListHead, car(temp));
	temp = UListHead;
	UListHead = assign(cdr(UListHead));
	release(temp);
	return(decrement(UListHead));
}

/****************Query Optimizer************************************/
#define NODEQNAME "InitNodQ"

void createInitialNode(Lptr CannonicalQuery) {
	Lptr CannonicalPattern;
	Lptr NodeQ;
	Lptr DescL;

	CannonicalPattern = assign(lread("(select >* QVars (from >* CasAIVar (elim (select >* AList (from >* CasAEVar (from >* EQListR))))))"));
	Match(CannonicalPattern, CannonicalQuery);

	NodeQ = addNode(mkstringatom(NODEQNAME)); // Create the Initial Node Q
 
	for (DescL = getBindVal(mkstringatom("QVars")); !vNull(DescL) ; DescL = cdr(DescL)) // Add all the QVars as foralla A.QVar
		addDescription(NodeQ, cons(mkstringatom("foralla"), cons(car(DescL), cons(cons(mkstringatom("atomic"), cons(mkstringatom("QVar"), getNil())), getNil()))));
	
	for (DescL = getBindVal(mkstringatom("CasAIVar")); !vNull(DescL) ; DescL = cdr(DescL)) {// Add all the IVars as foralla A.IVar and also the C as A using foralla A C
		addDescription(NodeQ, cons(mkstringatom("foralla"), cons(car(cdr(cdr(car(DescL)))), cons(cons(mkstringatom("atomic"), cons(mkstringatom("IVar"), getNil())), getNil()))));
		addDescription(NodeQ, cons(mkstringatom("foralla"), cons(car(cdr(cdr(car(DescL)))), cons(cons(mkstringatom("atomic"), cons(car(cdr(car(DescL))), getNil())), getNil()))));
	}

	for (DescL = getBindVal(mkstringatom("CasAEVar")); !vNull(DescL) ; DescL = cdr(DescL)) {// Add all the EVars as foralla A.EVar and also the C as A using foralla A C
		addDescription(NodeQ, cons(mkstringatom("foralla"), cons(car(cdr(cdr(car(DescL)))), cons(cons(mkstringatom("atomic"), cons(mkstringatom("EVar"), getNil())), getNil()))));
		addDescription(NodeQ, cons(mkstringatom("foralla"), cons(car(cdr(cdr(car(DescL)))), cons(cons(mkstringatom("atomic"), cons(car(cdr(car(DescL))), getNil())), getNil()))));
	}
	for (DescL = getBindVal(mkstringatom("EQListR")); !vNull(DescL) ; DescL = cdr(DescL)) // Add all the equalities
		addDescription(NodeQ, cons(car(car(DescL)),cons(cons(car(cdr(car(DescL))),car(cdr(cdr(car(DescL))))), cons(cons(car(cdr(cdr(cdr(car(DescL))))),car(cdr(cdr(cdr(cdr(car(DescL))))))), getNil()) )) );
	release(CannonicalPattern);
}

void QueryOptimizer(void){
	//Receive Q

	//Normalize Q to Description DQ

	//Create PD1 and Initialize to [Q:{DQ}]

	//Call expand1 on PD1

	//Initialize plan P and create description DP

	//Create PD2 and initialize to [P:{DP}]

	//Select next binding from PD1 and install in PD1, PD2 and P. If no bindings return "fail"

	//"Push" PD2, install ~DQ and call expand2 on PD2

	//if PD2 => Bottom then return P, otherwise call "Pop" on PD2 and repeat from (7)
}

static evalOkE 
eval_distinctL(Lptr Sexpr, Lptr *resultPP) {
	Lptr	arg1;
	evalOkE	get;

	get = args1(Sexpr, &arg1);
	if (get == eval_ok) {
		*resultPP = distinctL(arg1);
	}
	return(get);
}

static evalOkE
eval_enforceNewQ(Lptr Sexpr, Lptr *resultPP)
{
	Lptr	arg1;
	evalOkE	get;

	get = args1(Sexpr, &arg1);
	if (get == eval_ok) {
		*resultPP = enforceNewQ(arg1);
	}
	return(get);
}

void initoptimizer(void) 
{
	typedef struct {
		char	*nameP;
		evalOkE (*fun)(Lptr, Lptr *);
	} keywordT;

	static const keywordT entry[] =
	{
		"distinctL",			eval_distinctL,
		"enforceNewQ",			eval_enforceNewQ
	};

	int			i;

	for (i = 0; i < sizeof(entry)/sizeof(*entry); ++i) { 
		addfunc(entry[i].nameP, entry[i].fun);
}	}

