/***************************************************************************
 *                                  codegen.c
 *                              -------------------
 * Description               C code for memory manager
 ****************************************************************************/
/***************************************************************************
 *  *                                                                                                                                                 *
 *  *       This program is free software; you can redistribute it and/or modify  *
 *  *       it under the terms of the GNU General Public License as published by  *
 *  *       the Free Software Foundation; either version 2 of the License, or     *
 *  *       (at your option) any later version.                                   *
 *  *                                                                             *
 ****************************************************************************/

#include "config.h"

#include <assert.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h> 

#include "memmgr.h"
#include "tlisp.h"


static int FILE_CREATED = 0;
static int MEMMGR_INTRODUCED = 0;

FILE *output;
FILE *mainfunc;

static void
printheaders(FILE *output)
{
	char *headers =
	"/***************************************************************************\n"
	"								   memmgr.c  \n"
	"							 -------------------\n"
	"	Description 		  C code for memory manager\n"
	" ***************************************************************************/\n"
	"/***************************************************************************\n"
	" *									   *\n"
	" *	 This program is free software; you can redistribute it and/or modify  *\n"
	" *	 it under the terms of the GNU General Public License as published by  *\n"
	" *	 the Free Software Foundation; either version 2 of the License, or	   *\n"
	" *	 (at your option) any later version.								   *\n"
	" *													   *\n"
	" ***************************************************************************/\n"
	"\n"
	"#include <assert.h>\n"
	"#include <malloc.h>\n"
	"#include <stdio.h>\n"
	"#include <stdlib.h>\n"
	"#include <string.h> \n"
	"#include \"tlisp.h\"\n"
	"\n"
	;
	fprintf(output,headers);
}
void printfreecell(FILE *output)
{
	;
}

void printfreecellvtable(FILE *output)
{
	;
}

void printmemmgr(FILE *output)
{
	char *initmemmgr =
	"static void\n"
	"initMemBlock(memMgrT *stateP,memBlocksT *blocksP, freeT	*chainP)\n"
	"{\n"
	"char	*P, *nextP, *endP;\n"
	"int		entries, size;\n"
	"\n"
	"// Create a circular linked list\n"
	"\n"
	"entries = stateP->m_entries;\n"
	"size    = stateP->m_size;\n"
	"\n"
	"assert(entries && size);\n"
	"\n"
	"P       = blocksP->block;\n"
	"for (endP = P + entries * size; ; P = nextP) {\n"
	"	Vtable(P)    = &free_vtable;\n"
	"	nextP        = P + size;\n"
	"	if (nextP >= endP) {\n"
	"		break;\n"
	"	}\n"
	"	Next_free((freeT *) P) = (freeT *) nextP;\n"
	"}\n"
	"Next_free((freeT *) P)  = chainP;  // Close cyclic linked list\n"
	"stateP->m_prevP	   = (freeT *) P;  // Prev is what ever points to start of chain\n"
	"\n"
	"blocksP->nextP	   = stateP->m_headP;\n"
	"stateP->m_headP	   = blocksP;\n"
	"}\n"
	"void registerVtable(vtableT *vtableP, memMgrT *memmgrP)\n"
	"{\n"
	"unsigned int	size;\n"
	"memMgrT			*knownP;\n"
	"\n"
	"// Can't register the same class more than once\n"
	"assert(!vtableP->m_nextP);\n"
	"// Can't switch memmgrs once specified.\n"
	"assert(!vtableP->m_memmgrP);\n"
	"\n"
	"size = vtableP->function_sizeof();\n"
	"if (memmgrP) {\n"
	"	if (size < sizeof(freeT)) {\n"
	"		size = sizeof(freeT);\n"
	"	}\n"
	"	if (size > memmgrP->m_size) {\n"
	"		memmgrP->m_size = size;\n"
	"	}\n"
	"	vtableP->m_memmgrP = memmgrP;\n"
	"\n"
	"	for (knownP = g_memMgrsP; knownP; knownP = knownP->m_nextP) {\n"
	"		if (!knownP) {\n"
	"			memmgrP->m_nextP = g_memMgrsP;\n"
	"			g_memMgrsP       = memmgrP;\n"
	"			break;\n"
	"		}\n"
	"		if (knownP == memmgrP) {\n"
	"			break;\n"
	"	}	}\n"
	"}\n"
	"\n"
	"vtableP->m_nextP = g_vtablesP;\n"
	"g_vtablesP       = vtableP;\n"
	"}\n"
	"void initmemmgr(void)\n"
	"{\n"
	"registerVtable(&free_vtable, 0);\n"
	"registerVtable(&free_vtable_marked, 0);\n"
	"}\n";


	fprintf (output, initmemmgr);
}


static int		memmanagers_cnt	= 0;
///static int		max_memmanagers = 0;
static int  *managerarray;


void addmanager(char *nameP) 
{
	Sptr	sptr, func;

	
		if (!memmanagers_cnt) {
			memmanagers_cnt =1;
			managerarray = malloc(sizeof(int));
		} else {
			memmanagers_cnt++;
			managerarray = realloc(managerarray, sizeof(int) * memmanagers_cnt);
		}
		if (!managerarray) {
			fprintf(stderr, "Unable to grow managerarray\n");
			exit(1);
		}
	managerarray[memmanagers_cnt-1] = memmanagers_cnt;

	sptr = mkstringatom(nameP);
	func = assign(mkstringatom("memmanager"));
	putprop(sptr, func, mkintatom(memmanagers_cnt));
	release(func);
}

evalOkE mem_manager(Lptr Sexpr, Lptr *resultPP)
{
	Lptr arg1, arg2, arg3, tempLptr;
	Lptr mgrname;
	Sptr tempSptr;
	int val2;
	int ret;
	char *tempstr;
	evalOkE get;
	if (!FILE_CREATED)
	{
		output = fopen("generated.c","w");
		mainfunc = fopen("main.c","w");
		printheaders(output);
		printfreecell(output);
		printfreecellvtable(output);
		FILE_CREATED = 1;
	}

	if (!MEMMGR_INTRODUCED)
	{
		printmemmgr(output);
		MEMMGR_INTRODUCED = 1;
	}
	
	get = args3(Sexpr, &arg1, &arg2, &arg3);
	if (get == eval_ok) {
		mgrname = arg1;
		arg1 = assign (eval(arg1));
		if (Vtype(arg1) == STRTYPE )
		{
			mgrname = arg1;
		}
		if (Vtype(mgrname) != STRTYPE) {
			return(eval_bad_arg);
		}
		else {
			tempSptr = mgrname;
			tempstr = malloc(stringLth(Start_frag(tempSptr))*sizeof(char));
			strStoreToString(Start_frag(tempSptr),tempstr);
			addmanager(tempstr);
			ret = getAtomIntVal(arg2, &val2);
			release(arg2);
			if (!ret) {
				return(eval_bad_arg);
			}
			tempLptr = arg3;
			while (Vtype(tempLptr) != NILTYPE)
			{
				
				tempSptr = Car(tempLptr);
				tempstr = malloc(stringLth(Start_frag(tempSptr))*sizeof(char));
				strStoreToString(Start_frag(tempSptr),tempstr);
				tempLptr = Cdr(tempLptr);
			//how to get a list of the supported type
			//idea about main function i.e. where to give the initialisation command
			}
			
			release(arg1);
		}
	}
	
	return (eval_ok);
}



evalOkE no_memmanager(Lptr Sexpr, Lptr *resultPP)
{
	Lptr arg1;
	evalOkE get;
	if (!FILE_CREATED)
	{
		output = fopen("generated.c","w");
		printheaders(output);
		printfreecell(output);
		printfreecellvtable(output);
		FILE_CREATED = 1;
	}

	if (!MEMMGR_INTRODUCED)
	{
		printmemmgr(output);
		MEMMGR_INTRODUCED = 1;
	}
	
	
	get = args1(Sexpr, &arg1);
	if (get == eval_ok) {
		
		//handle variable number of arguments
		
	}

	


	return (eval_ok);
}



	
	


evalOkE default_memmanager(Lptr Sexpr, Lptr *resultPP)
{
	Lptr arg1;
	evalOkE get;
	if (!FILE_CREATED)
	{
		output = fopen("generated.c","w");
		printheaders(output);
		printfreecell(output);
		printfreecellvtable(output);
		FILE_CREATED = 1;
	}

	if (!MEMMGR_INTRODUCED)
	{
		printmemmgr(output);
		MEMMGR_INTRODUCED = 1;
	}
	
	
	get = args1(Sexpr, &arg1);
	if (get == eval_ok) {
		
		//ask ian how to get the defaultmemmanager to point to this
		
	}

	


	return (eval_ok);
}
void initcodegen(void)
{
	addfunc ("newmemmgr",mem_manager);
	addfunc ("defaultmemmgr",default_memmanager);
	addfunc ("nomemmgr",no_memmanager);
	
}