/***************************************************************************
								  cgu.h  
							 -------------------
	Description 		  Header file for Common Graph Utility (CGU)
 ***************************************************************************/
/***************************************************************************
 *																		   *
 *	 This program is free software; you can redistribute it and/or modify  *
 *	 it under the terms of the GNU General Public License as published by  *
 *	 the Free Software Foundation; either version 2 of the License, or	   *
 *	 (at your option) any later version.								   *
 *																		   *
 ***************************************************************************/


#ifndef _GTAB_CGU_H
#define _GTAB_CGU_H

#define ERR_GEN -100			   /* general error code */
#define ERR_DESC_NOT_MATCH -101    /* Description does not match with any of the standard patterns.*/
#define ERR_PDID_NOT_MATCH -102    /* Cannot find the PDid in the PD List */
																			

boolean negationNormalForm(Lptr Form); /*remove later.It should be called within the reasoner API*/

/**
@short Terminate the control program for the Negation Normal Form.

It will basically free the memory used for all the variables in the control
program for the Negation Normal Form. If called in the middle of the program the variables will
get reloaded in the next call to negationNormalForm */
void finalizeNNFControl(void);

/* New version of reasonerapi.h  */

/* define the cases used in Expand1 */
#define TOP 1
#define BOTTOM 2
#define Atomic_C 3
#define Not_Atomic_C 4
#define NFPD 5
#define And_D1_D2 6
#define Equal_Path 7
#define Path_Id1 8
#define Path_Id2 9
#define Nequal_Paths 10
#define DatF 11
#define Forall_F_D1 12
#define Or_D1_D2 13

#define Delete TRUE
#define Do_Not_Delete FALSE

/**
@short Initializes the temporary patterns used by function in reasonerapi.c file.
*/
void init_tmpPatterns(void);

/**
@short Release all the temporary patterns that were initialized by init_tmpPatterns.
*/
void finalize_tmpPatterns(void);

/**
@short Creates a new Partial Database.

Creates a new PD and inserts it in the <list of PDs>
If "CGUData" is NULL then it intializes it also.

A PD is a list of 5 elements
	 1st element --> pointer to "PDid"
	 2nd element --> pointer to "poplog"
	 3rd element --> pointer to stack1 (used for expand1)
	 4th element --> pointer to stack2 (used for expand2)
	 5th element --> a pointer to list of nodes.
It returns the pointer to "newPD".
Note: stack1 and stack2 are lists. Each element of the list is a pair of 2 things.
		1st thing is node-id and 2nd is description.
@param PDid Atom. Id of PD to be created.
@returns Pointer to the newly created PD.
*/

Lptr createPD (Lptr PDid) ;

/**
@short Sets the currPD to PD with id = "PDid"
Sets the currPD pointer to PD whose Id is "PDid".
@param PDid Atom. Id of the Pd which has to be made current PD.
@returns Pointer to currPD, i.e, PD with id = "PDid"
*/

Lptr setPD(Lptr PDid) ;


/**
@short Deletes the PD with id = "PDid"
Deletes the PD from the PDList and also releases the memory.
@param PDid Atom. Id of the PD to be deleted
*/
void deletePD (Lptr PDid);

/**
@short Add a global inclusion dependency
It adds a global dependency. If "CGUData" is NULL then it intializes it also.
@param LHS It can be either atom or list.
  If its atom, the lhs and rhs of inclusion dependency added remain same as LHS and RHS.
  If it is a list and it matches (atomic > C), then lhs of inclusion dependency added becomes "C" and rhs remains same as RHS.
  If it is a list and it doesn't match (atomic > C), then lhs of inclusion dependency added becomes "top" and rhs becomes (or RHS (not LHS))
@param RHS List.
*/

Lptr addGlobalIncDep (Lptr LHS, Lptr RHS) ;
/**
@short Same as addGlobalIncDep
At present, it just calls addGlobalIdep. But the idea is, it can be used to add inclusion
dependencies in only one particular database, normally in currPD.
@param LHS see description in addGlobalIncDep
@param RHS see description in addGlobalIncDep
*/

Lptr addLocalIncDep (Lptr LHS, Lptr RHS) ;

/**
@short Adds the node to currPD.
Adds the node to currPD. Also adds a property with indicator as id of currPD and value as null
description list in the property list of that node. If there is a global inclusion dependency with
LHS as "top", then it pushes the RHS of that IDep and this node in stack1.
@param NodeId Atom. The Id which the new node should have.
@returns NodeId
*/
Lptr addNode(Lptr NodeId) ;

/**
@short no idea...ask Alex :)
*/
Lptr newQC(Lptr LHS, Lptr RHS) ;

/**
@short Deletes CGUData.
Deletes all the inclusion dependencies and all the PDs. And thus releases all the memory.
Sets "everyTing" and "currPD" to NULL. Also calls resetLogVer and finalizeNNFControl.
*/
void finalizePD(void) ;

/**
@short Returns true if the stack is empty.
Returns true if the stack is empty.
@param stackHead Pointer to a cons cell which is head of the stack
@returns TRUE or FALSE depending on whether stack is empty or not.
*/
boolean isEmptyStack (Lptr stackHead) ;

/**
@short Pushes in stack a pair of description and node.
It forms a stack element which is a list of description and node.
It then pushes that element in the stack.
@param stackHead head of the stack in which to push
@param Desc The description to be added.
@param name The name of the node to be added.
@returns The stackHead
*/

Lptr pushStack (Lptr stackHead,Lptr Desc,Lptr name) ;

/**
@short Pops and returns the top element of the stack
Pops and returns the top element of the stack.
@param stackHead Pointer to a cons cell which is head of the stack
@returns The top element of the stack.
*/
Lptr popStack(Lptr stackHead) ;

/**
@short Returns the PD pointed to by currPD.
@returns the PD pointed to by currPD.

*/
Lptr getCurrPD(void) ;

/**
@short Adds an edge from "node1" to "node2" with label as "label".
It adds an edge from "node1" to "node2" with label as "label" if there isn't already an edge from "node1"
with "label". After adding the edge, it checks whether there is an (waitf...) description in "node1"
that can be processed. If that is the case, then it does so.
By adding an edge, it means adding the description (edge <sink node> <label>) in source node and adding
description (redge <source node> <label>) in sink node.
@param node1 Atom. The source node
@param node2 Atom. The sink node
@param label Atom. The label of thee edge.

*/

void add_Edge(Lptr node1,Lptr node2,Lptr label) ;

/**
@short Checks if inequality edge exists between node1 and node2 or not.
Checks if inequality edge exists between node1 (or its eqclass) and node2 (or its eqClass) or not.
By existence of in equality edge we mean, existence of description (ineq <other node>).
@param node1 Atom. First node
@param node2 Atom. Second node
@returns TRUE if inequality edge exists or FALSE if it doesn't.
*/
boolean exists_Ineqality_Edge(Lptr node1, Lptr node2);

/**
@short Adds equality edge between node1 and node2.
It actually randomly selects either node1 or node2 and sets its equivalance class to other.
@param node1 Atom. The first node.
@param node2 Atom. The second node.
@returns TRUE if there was no clash while adding the equality and FALSE it there was a clash.
*/
boolean add_Equality (Lptr node1,Lptr node2);

/**
@short Adds inequality edge  between node1 and node2.
It adds descriptions (ineq <other node>) in both the nodes indicating an inequality edge between
the two nodes. If the two nodes have redges with same labels then those nodes which are pointed to
by redges are also made inequal.
@param node1 Atom. first node
@param node2 Atom. second node
@returns TRUE if there was no clash otherwise FALSE.
*/

boolean add_Inequality (Lptr node1, Lptr node2);

/**
@short Traces a given path from a node (or creating the path, if it doesn't already exist) and returns
the final node reached.
@param fromNode Atom. Starting node
@param Path List. List of edges forming the path
@returns The node reached by tracing the path.
*/
Lptr findPath(Lptr fromNode,Lptr Path) ;

Lptr findEdge(Lptr node, Lptr label) ;
void addDescription(Lptr Node,Lptr Desc);
void delDescription(Lptr Node,Lptr Desc) ;
Lptr getEqClass(Lptr Node) ;
Lptr getRHS (Lptr LHS);
Lptr createNode(Lptr lbl) ;
Lptr isDescInNode (Lptr Pat, Lptr node, boolean deletePat) ;
void finalizePatterns(void);
void checkPath(Lptr Ni,Lptr N,Lptr Flist,Lptr C,Lptr D2);

/* expand1 and expand2 are basic functions for CGU */
boolean expand1();
boolean expand2();

#endif
