/***************************************************************************
								   tlisp.h	
							 -------------------
	Description 	  Header File for memmgr.h version.h hash.h and tlisp.h
 ***************************************************************************/
/***************************************************************************
 *																		   *
 *	 This program is free software; you can redistribute it and/or modify  *
 *	 it under the terms of the GNU General Public License as published by  *
 *	 the Free Software Foundation; either version 2 of the License, or	   *
 *	 (at your option) any later version.								   *
 *																		   *
 ***************************************************************************/

#ifndef _GTAB_TLISP_H
#define _GTAB_TLISP_H

typedef union memblkS *Iptr;	// An integer atom
typedef union memblkS *Fptr;	// A fragment of a string addressed by a string atom
typedef union memblkS *Sptr;	// A string atom
typedef union memblkS *Aptr;	// An atom -- either an Iptr or a Sptr
typedef union memblkS *Cptr;	// A cons cell including nil
typedef union memblkS *Lptr;	// A lisp pointer -- either an atom or a cons cell
typedef union memblkS *Bptr;	// A boolean lisp value "t" or nil
typedef union memblkS *Hptr;	// A pointer to the next string atom on the heap or nil
typedef union memblkS *Uptr;	// A currently unallocated block of memory
typedef union memblkS *Mptr;	// A memory block pointer to something

// Export so higher level software may use tlisp's mem manager if wish to
extern memMgrT	g_memmgr;

Cptr getNil(void);
Sptr getUndef(void);
Lptr getError(void);

Lptr assign(Lptr Sc);
Lptr decrement(Lptr Sc);
void release (Lptr Snode);
void setSptr(Lptr *globalP, Lptr Sc);

/* define macros for a way around unnmaed structs in C */

typedef struct consS {
	const vtableT *vtableP;
	int			rcount;
	unsigned int version;
	Lptr 		car;			 /* car pointer */
	Lptr 		cdr;			 /* cdr pointer */
} consT;

#define Rcount(X) (X)->cons.rcount
#define Version(X) (X)->cons.version
#define Car(X) (X)->cons.car
#define Cdr(X) (X)->cons.cdr


typedef struct intS {
	const vtableT *vtableP;
	int			rcount;
	Lptr 		def;	   /* def pointer */
	Hptr 		nexthash; /* hash pointer, 0 if not currently in hash table */	
	int			intval;
} intT;

#define Def(X) (X)->integer.def
#define Nexthash(X) (X)->integer.nexthash
#define Intval(X) (X)->integer.intval

typedef struct stringS {
	const vtableT *vtableP;
	int			rcount;
	Lptr 		def;			/* def pointer */
	Hptr 		nexthash;		/* hash pointer, 0 if not currently in hash table */	
	Fptr 		start_frag;		/* string: pointer to a list of string cells */
} stringT;

#define Start_frag(X) (X)->string.start_frag

typedef union memblk0S {
	consT	cons;
	intT	integer;
	stringT	string;
	freeT	free;
} MemBlock0;


/* array of char, serving as parts of an arbitrarily long string*/ 

/* Max length of strings in string cell */
#define STRSIZE (sizeof(MemBlock0) - sizeof(vtableT *) - sizeof(Fptr) - 1 /* Leave space for \0 in each fragment */)

typedef struct fragS {
	const vtableT *vtableP;
	char 		strdata[STRSIZE + 1];
	Fptr		next_frag;
} fragT;

#define Strdata(X) (X)->frag.strdata
#define Next_frag(X) (X)->frag.next_frag

typedef union memblkS {
	consT	cons;
	intT	integer;
	stringT	string;
	fragT	frag;
	freeT	free;
} MemBlock;

/* --------------------------------------
 * Start of what used to be version.h
 * -------------------------------------
 */

int getVersion(Cptr S2node);

void resetLogVer(void);

Lptr cons(Lptr incar, Lptr incdr);
Lptr car(Cptr Snode);
Lptr cdr(Cptr Snode);
Lptr rplaca(Cptr S2node, Lptr Sanode);
Lptr rplacd(Cptr S2node, Lptr Sdnode);

int getCurrentVersion(void);

void beginVer(void);
void commitVer(void);
void abortVer(void);

/* ------------------------------------
 * Start of what used to be hash.h
 * ------------------------------------
 */

#define MAXHASHSIZE 128 /* It has to be a power of 2 */

Hptr firstatom(void);
Hptr nextatom(Hptr after);
void addhash(Sptr Snode);
Sptr findhashstr(char *stringval);
void remob(Sptr Snode);
void finalizeHash(void);

/* ------------------------------------
 * Start of what used to be nlisp.h
 * ------------------------------------
 */

/****************************************************************************
 * Parser Part																*
 ****************************************************************************/
typedef enum {
	ERROR	   = 0,
	WHITESPC   = 1,
	OPENPRTS   = 2,
	CLOSEPRTS  = 3,
	NUMBER	   = 4,
	LETTER	   = 5,
	SPECIALCHR = 6
} tokentypeE;

/******************************************************************************
 * Store Part																  * 										
 ******************************************************************************/

// define TRUE and FALSE
#define TRUE 1
#define FALSE 0
#define boolean short int

typedef enum {
	eval_ok 			= 0,
	eval_illegal_arg	= 1,
	eval_illegal_name	= 2,
	eval_too_few		= 3,
	eval_too_many		= 4,
	eval_bad_arg		= 5,
	eval_outofmem		= 6,
	eval_undef			= 7,
	eval_func_missing	= 8,
	eval_func_not_func	= 9,
	eval_func_not_int	= 10,
	eval_func_range_err = 11,
	eval_cant_abort     = 12,
	eval_not_proplist   = 13
} evalOkE;

// Parser functions
tokentypeE getCharType(char c);
Lptr getToken(tokentypeE *toktype, char *inputstr, int *pos);

Sptr stringToStrStore(char *Stringval);
void strStoreToString(Sptr atomstr, char* Stringval);
unsigned int stringLth(Sptr strstore);
int stringcmp(Sptr Strblk, char *strval);
int storecmp(Fptr Strblk1, Fptr Strblk2);
void finish(void);

//Functions in soper
int getAtomIntVal(Lptr Snode, int *valP);
int getAtomStrStore(Lptr Snode, Fptr *resultPP);

boolean iscvr(char* v);
boolean vAtom(Lptr Snode);
boolean vNull(Lptr Snode);
boolean vListp(Lptr Snode);
Lptr set(Lptr Snode, Lptr Slnode);
Lptr eval(Lptr Sexpr); // in evaluate.c
boolean nullEval(Lptr Sexpr);
Iptr mkintatom(int val);
Sptr mkstringatom(char *Stringval);
Aptr mkatom(char *Stringval);
Lptr getTrue(void);
Lptr getList(char *Stringval, int*pos);
Lptr lread(char *Stringval);
// new in soper
boolean eql(Aptr S2, char* stringtc);
boolean eq(Aptr E1, Aptr E2);
boolean neq(Aptr E1, Aptr E2);
int atomcmp(Aptr atom1, Aptr atom2);
int compareS(Lptr Snode1, Lptr Snode2);
void gensym_init(void);
Lptr gensym(char* newprefix);
Lptr getprop(Lptr symbol, Lptr indicator);
Lptr putprop(Lptr symbol, Lptr indicator, Lptr value);
Lptr remprop(Lptr symbol, Lptr indicator);
Lptr append(Lptr x, Lptr y);
Lptr last(Lptr inList);
Lptr insertSortList(Lptr Head, Lptr Element);
Lptr listUnion(Lptr L1, Lptr L2); 
boolean member(Lptr x, Lptr y);
Lptr assq(Lptr key, Lptr alist);

Lptr findPrevList(Lptr List, Lptr Node);
Lptr findListHead(Lptr List, Lptr Node);
Lptr addList (Lptr ListHead, Lptr Node);
Lptr removeList (Lptr ListHead, Lptr Node);
Lptr updateList (Lptr ListHead, Lptr oldNode, Lptr newNode);
Lptr getprophead(Lptr symbol, Lptr indicator);
Lptr getph_fd(Lptr symbol, Lptr indicator, Lptr (*feval) (Lptr));

Lptr vaddList(Lptr ListHead, Lptr Node);

evalOkE args0(Lptr Sexpr);
evalOkE args1(Lptr Sexpr, Lptr *arg1P);
evalOkE args1_2(Lptr Sexpr, Lptr *arg1P, Lptr *arg2P);
evalOkE args2(Lptr Sexpr, Lptr *arg1P, Lptr *arg2P);
evalOkE args3(Lptr Sexpr, Lptr *arg1P, Lptr *arg2P, Lptr *arg3P);

void addfunc(char *nameP, evalOkE (*fun)(Lptr, Lptr *)); 
void inittlisp(void);

#endif
