/***************************************************************************
								  sprint.c	 
							 -------------------
	Description 		   C File of Printing Utility
 ***************************************************************************/
/***************************************************************************
 *																		   *
 *	 This program is free software; you can redistribute it and/or modify  *
 *	 it under the terms of the GNU General Public License as published by  *
 *	 the Free Software Foundation; either version 2 of the License, or	   *
 *	 (at your option) any later version.								   *
 *																		   *
 ***************************************************************************/

#include "config.h"

#include <assert.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>

#ifndef WIN32
#include <unistd.h>
#endif
#include <stdarg.h>

#include "memmgr.h"
#include "tlisp.h"
#include "sprint.h"
#include "lsedit.h"

void
sprint_init(sprintT *targetP)
{
	targetP->m_lth = 0;
	targetP->m_P   = 0;
	targetP->m_size = 0;
}
void
sprint_free(sprintT *targetP)
{
	free(targetP->m_P);
	targetP->m_P = 0;
	targetP->m_size = 0;
}

void 
print(sprintT *targetP, const char *fmtP, ...)	/* proc */
{
	va_list arg;
	int 	size, left, ret, at;
	char	*P;
	
	va_start(arg, fmtP);
	
	if (!fmtP) fmtP = "**NO FORMAT STRING**\n";

	if (!targetP) {
		if (vprintf(fmtP, arg) < 0) {
			goto cant_print;
		}
		return;
	}
	P = targetP->m_P;
	if (!P) {
		targetP->m_lth = 0;
		P			   = malloc(256);
		if (!P) {
			goto outofmemory;
		}
		targetP->m_P   = P;
		targetP->m_size=256;
	}

	at = targetP->m_lth;
	for (;;) {
		size = targetP->m_size;
		left = size - at;
		// Caution: microsoft bug causes ret == -1 if printing any 0xFFFF character
		if (left > 79 && (ret = _vsnprintf(P+at, left, fmtP, arg)) >= 0) {
			break;
		}
		size <<= 1;
		if (size & 0x40000000) {
			goto cant_print;
		}
		P = realloc(P, size<<1);
		if (!P) {
			goto outofmemory;
		}
		targetP->m_P = P;
	}
	targetP->m_lth += ret;
	va_end(arg);
	return;
outofmemory:
	fprintf(stderr, "Out of memory in sprintf_printf\n");
	exit(1);
cant_print:
	// Very serious problems trying to print whatever it might be..
	fprintf(stderr, "<<Can't print>> %s\n", fmtP);
	exit(1);
}

// Print internal structures

void print_stringS(sprintT *targetP, Lptr Sc)
{
	Lptr	temp;
	int 	quote = 0;
	char	*P;
	int 	c;

	for ( temp = Start_frag(Sc); temp != NULL && !quote ;temp = Next_frag(temp) ) {
		for (P = Strdata(temp); c = *P; ++P) {
			if ( (c<'a' || c > 'z') && (c < 'A' || c > 'Z') && (c < '0' || c > '9')) {
				quote = 1;
				print(targetP, "\"");
				break;
	}	}	}

	for (temp = Start_frag(Sc); temp != NULL ; temp = Next_frag(temp) ) {
		print(targetP, "%s",Strdata(temp));
	}
	if (quote) {
		print(targetP, "\' ");
	} else {
		print(targetP, " ");
	}
	return;
}

/* PRINTS FUNCTION VERSIONED */

void printS(sprintT *targetP, Lptr Sc) {

	if (!Sc) {
		print(targetP, "<<NULL>> ");
		return;
	}
	switch (Stype(Sc)) {
		case INTTYPE :
		print(targetP, "%i ", Intval(Sc));
		break;

		case STRTYPE :
		print_stringS(targetP, Sc);
		break;

		case CONSTYPE :
		{
			Lptr temp; 
			int isList = 0;

			for(temp = Sc; ; temp = cdr(temp)) {
				switch (Stype(temp)) {
				case CONSTYPE:
					continue;
				case NILTYPE:
					isList = 1;
					break;
				}
				break;
			}
			print(targetP, "( ");
			if (isList) {
				for (temp = Sc; Stype(temp) != NILTYPE; temp = cdr(temp)) {
					printS(targetP, car(temp));
				}
			} else {
				printS(targetP, car(Sc));
				print(targetP, ". ");
				printS(targetP, cdr(Sc));
			}
			print(targetP, ") ");
			break;
		}
		case NILTYPE:
		print(targetP, "() ");
		break;

		case UNDEFTYPE:
		print(targetP, "*UNDEF* ");
		break;

		case ERRORTYPE:
		print(targetP, "*ERROR* ");
		break;

		case FRAGTYPE:
		print(targetP, "<<!!FRAG!!>> ");
		break;

		case FREETYPE:
		print(targetP, "<<!!FREEMEM!!>> ");
		break;

		default:
		assert(0);
	}
}

/* Print the information of a partial database
   ===========================================
   Parameter:
	 pd is the pointer to the partial database
   ===========================================
*/
void printPD(sprintT *targetP, Lptr pd) {
  Lptr eval1;
  Lptr list, iter, nodeid;

/*
	lseditT parms = { "..", 1, 1, 1};
	dump_lsedit(&parms, pd);
*/

  list = pd;
  print(targetP, "\n PD-id : ");
  printS(targetP, car(list));
  list = cdr(list); 	// cdr(pd)
  print(targetP, "\n PopLog : ");
  printS(targetP, car(list));
  list = cdr(list); 	// cdr(cdr(pd))
  print(targetP, "\n Stack1 : ");
  printS(targetP, car(list));
  list = cdr(list); 	// cdr(cdr(cdr(pd)))
  print(targetP, "\n Stack2 : ");
  printS(targetP, car(list));
  list = cdr(list); 	// cdr(cdr(cdr(cdr(pd))))
  print(targetP, "\n Node-list : \n");
  for (iter = car(list); !vNull(iter) ; iter = cdr(iter)) {
	print(targetP, "  node-id :");
	nodeid = car(iter);
	printS(targetP, nodeid);
	eval1 = assign(eval(nodeid));
	printS(targetP, eval1);
	release(eval1);
	print(targetP, "\n");
  }
  print(targetP, "\n");
}

/* Print all things in the database, including the global inclusion
   dependencies and all PD info */
void printEveryThing(sprintT *targetP) {

  extern Lptr CGUData;

  Lptr iter, eval1;

  print(targetP, "\n*****Printing CGUData***** \n LHS-list :\n");
  //iprintS(targetP, car(CGUData));
  for (iter = car(CGUData); !vNull(iter) ; iter = cdr(iter)) {
	print(targetP, "  LHS :");
	printS(targetP, car(iter));
	eval1 = assign(eval(car(iter)));
	printS(targetP, eval1);
	release(eval1);
	print(targetP, "\n");
  }
  print(targetP, "\n");
  print(targetP, "\n The PDs are as follows : ");
  for (iter = cdr(CGUData) ; Stype(iter) != NILTYPE ; iter= cdr(iter))
	printPD(targetP, car(iter));
  print(targetP, "*****End of printing CGUData ***** \n");
}

static evalOkE
eval_print(Lptr Sexpr, Lptr *resultPP) {
	Lptr	args, arg;

	arg = 0;
	for (args = Sexpr; !vNull(args); args = cdr(args)) {
		if (arg) {
			release(arg);
		} else {
			printf("print: ");
		}
		arg = assign(eval(car(args)));
		printS(0, arg);
	}
	if (arg) {
		printf("\n");
	}
	*resultPP = decrement(arg);
	return(eval_ok);
}

void initsprint(void) 
{
	typedef struct {
		char	*nameP;
		evalOkE (*fun)(Lptr, Lptr *);
	} keywordT;

	static const keywordT entry[] =
	{
		"print",				eval_print
	};

	int			i;

	for (i = 0; i < sizeof(entry)/sizeof(*entry); ++i) { 
		addfunc(entry[i].nameP, entry[i].fun);
}	}

