/***************************************************************************
								  reasoner.c  
							 -------------------
	Description 		  C File for Description Logic (DL) Reasoner
 ***************************************************************************/
/***************************************************************************
 *																		   *
 *	 This program is free software; you can redistribute it and/or modify  *
 *	 it under the terms of the GNU General Public License as published by  *
 *	 the Free Software Foundation; either version 2 of the License, or	   *
 *	 (at your option) any later version.								   *
 *																		   *
 ***************************************************************************/

#include "config.h"
#include <stdio.h>

#include "memmgr.h"
#include "tlisp.h"
#include "cgu.h"

extern Lptr PDList;
extern Lptr currPD ;

Lptr inKnowledgeBase(Lptr PDid) {
	if (currPD==NULL) {
		createPD(PDid);
		setPD(PDid);
	}
	else if(!eq(car(currPD), PDid) ) {
		Lptr temp;

		for (temp=PDList; !Stype(temp) == NILTYPE && (car(car(temp)) != PDid) ; temp=cdr(temp));
		if (vNull(temp)) {
			createPD(PDid);
			setPD(PDid);
		}
		else
			setPD(PDid);
	}
	return (PDid);
}

Lptr implies(Lptr LHS, Lptr RHS) {
	return(addLocalIncDep(LHS, RHS));
}

Lptr equivalent(Lptr LHS, Lptr RHS) {
	addLocalIncDep(LHS,RHS);
	return(addLocalIncDep(RHS, LHS));
}

Lptr satisfiable(Lptr D) {
	Lptr currStack1 = cdr(cdr(currPD)) ;					//Head of stack1
	Lptr D1;
	
	//beginVer();
	D1=assign(lread("(forall SaTsNoDe ())"));
	rplaca(cdr(cdr(D1)),D);
	pushStack(currStack1,D1,lread("PDNDROOT"));
	release(D1);
	if (expand1()) {
		if(expand2())
			return (lread("t"));
		else
			return (getNil());
		}
	return (getNil());
}

Lptr subsumes(Lptr D2, Lptr D1) {
	Lptr currStack1 = cdr(cdr(currPD)) ;					//Head of stack1
	Lptr D;

	//beginVer();
	D=assign(lread("(forall SuBsNoDe ())"));
	rplaca(cdr(cdr(D)),newQC(D1,D2));
	pushStack(currStack1,D, lread("PDNDROOT"));
	release(D1);
	if (!expand1() || !expand2()) {
		return (lread("t"));
	}
	return (getNil());
}

Lptr conceptAncestors(Lptr concept) { // Not yet implemented
	Lptr AncList = 0;

	return(AncList);
}

Lptr conceptDescendants(Lptr concept) { // Not yet implemented
	Lptr DescList = 0;
	return(DescList);
}

static evalOkE
eval_conceptAncestors(Lptr Sexpr, Lptr *resultPP)
{
	Lptr	arg1;
	evalOkE	get;

	get = args1(Sexpr, &arg1);
	if (get == eval_ok) {
		*resultPP = conceptAncestors(arg1);
	}
	return(get);
}

static evalOkE 
eval_conceptsubsumes(Lptr Sexpr, Lptr *resultPP) {
	Lptr	arg1, arg2;
	evalOkE	get;

	get = args2(Sexpr, &arg1, &arg2);
	if (get == eval_ok) {
		*resultPP = subsumes(arg1, arg2);
	}
	return(get);
}

static evalOkE
eval_conceptDescendants(Lptr Sexpr, Lptr *resultPP)
{
	Lptr	arg1;
	evalOkE	get;

	get = args1(Sexpr, &arg1);
	if (get == eval_ok) {
		*resultPP = conceptDescendants(arg1);
	}
	return(get);
}

static evalOkE
eval_equivalent(Lptr Sexpr, Lptr *resultPP) {
	Lptr	arg1, arg2;
	evalOkE	get;

	get = args2(Sexpr, &arg1, &arg2);
	if (get == eval_ok) {
		*resultPP = equivalent(arg1, arg2);
	}
	return(get);
}

static evalOkE 
eval_implies(Lptr Sexpr, Lptr *resultPP) {
	Lptr	arg1, arg2;
	evalOkE	get;

	get = args2(Sexpr, &arg1, &arg2);
	if (get == eval_ok) {
		*resultPP = implies(arg1, arg2);
	}
	return(get);
}

static evalOkE 
eval_inKnowledgeBase(Lptr Sexpr, Lptr *resultPP) {
	Lptr	arg1;
	evalOkE	get;

	get = args1(Sexpr, &arg1);
	if (get == eval_ok) {
		*resultPP = inKnowledgeBase(arg1);
	}
	return(get);
}

void initreasoner(void) 
{
	typedef struct {
		char	*nameP;
		evalOkE (*fun)(Lptr, Lptr *);
	} keywordT;

	static const keywordT entry[] =
	{
		"concept-ancestors",	eval_conceptAncestors,
		"concept-descendants",	eval_conceptDescendants,
		"concept-subsumes?",	eval_conceptsubsumes,
		"equivalent",			eval_equivalent,
		"implies",				eval_implies,
		"in-knowledge-base",	eval_inKnowledgeBase
	};

	int			i;

	for (i = 0; i < sizeof(entry)/sizeof(*entry); ++i) { 
		addfunc(entry[i].nameP, entry[i].fun);
}	}

