/***************************************************************************
								   tlisp.h	
							 -------------------
	Description 	  Header File for memmgr.h version.h hash.h and tlisp.h
 ***************************************************************************/
/***************************************************************************
 *																		   *
 *	 This program is free software; you can redistribute it and/or modify  *
 *	 it under the terms of the GNU General Public License as published by  *
 *	 the Free Software Foundation; either version 2 of the License, or	   *
 *	 (at your option) any later version.								   *
 *																		   *
 ***************************************************************************/

#ifndef _GTAB_MEMMGR_H
#define _GTAB_MEMMGR_H

/* define S cell types  */

typedef enum {
	FREETYPE  = 0,

	/* Atomic types */
	INTTYPE   = 1,
	STRTYPE   = 2,
	/* Non-atomic types */
	CONSTYPE  = 3,
	UNDEFTYPE = 4,
	ERRORTYPE = 5,
	NILTYPE   = 6,

	/* Special types */
	FRAGTYPE  = 7,
	BADTYPE   = 8
} celltypeE;

struct memMgrS;

typedef struct vtableS {
	int			(*function_sizeof)(void);
	celltypeE	(*function_stype)(void);
	const char *(*function_name)(void);
	void		(*function_dump)(void *, FILE *);
	int			(*function_empty)(void *);
	void		(*function_setmark)(void *);
	void		(*function_clrmark)(void *);
	int			(*function_ismarked)();

	struct memMgrS	*m_memmgrP;
	struct vtableS	*m_nextP;
} vtableT;

typedef struct freeS {
	const vtableT	*vtableP;
	struct freeS	*next_free;
} freeT;

typedef struct MemBlocks {
	struct MemBlocks	*nextP;
	char				block[1];	// Real size m_entries * m_size
} memBlocksT;

typedef struct memMgrS {
	struct memMgrS		*m_nextP;
	unsigned int		m_entries;
	unsigned int		m_size;
	memBlocksT			*m_headP;
	freeT				*m_prevP;
} memMgrT;

/* define macros for a way around unnamed structs in C */

#define Vtable(X) ((freeT *) X)->vtableP

#define Vsizeof(X)		( Vtable(X)->function_sizeof() )
#define Stype(X)		( Vtable(X)->function_stype() )
#define Vname(X)		( Vtable(X)->function_name() )
#define Vdump(X, F)		( Vtable(X)->function_dump(X, F) )
#define Vempty(X)		( Vtable(X)->function_empty(X) )
#define Vsetmark(X)		( Vtable(X)->function_setmark(X) )
#define Vclrmark(X)		( Vtable(X)->function_clrmark(X) )
#define Vismarked(X)	( Vtable(X)->function_ismarked() )

#define Next_free(X) ((freeT *) X)->next_free
 
extern int is_false(void);
extern int is_true(void);

freeT *getMemBlock(vtableT *vtableP);
void  freeMemBlock(freeT *memP);

void printFreeStats(memMgrT *stateP);
void printAllFreeStats(void);
void registerVtable(vtableT *vtableP, memMgrT *memmgrP);
void initmemmgr(void);

#endif
