
% CS787.  Assignment #1, Question #2.
%
% Demo of 2D Gabor filters.
%
% NOTE: You must be in matlab-tutorial directory to run this program.
%       (for help on functions type "help mkSine", "help mkGaussian", etc)

sz=64; % size of image patch for demos

% A Gabor function is a product of a Gaussian and a sinusoid:
% Power spectrum is Gaussian.
im = mkGaussian(sz,10) .* mkSine(sz,8);
subplot(1,2,1); showIm(im);
subplot(1,2,2); showIm(fftshift(abs(fft2(im))));
drawnow

% Phase shift in time domain doesn't change power spectrum
% Here we show a "cosine" gabor, ie., shift by pi/2
im = mkGaussian(sz,6) .* mkSine(sz,8,0,1,pi/2);
subplot(1,2,1); showIm(im,[-0.02,0.02]);
subplot(1,2,2); showIm(fftshift(abs(fft2(im))));
drawnow

% Increasing frequency moves peaks away from origin in freq domain
im = mkGaussian(sz,6) .* mkSine(sz,4);
subplot(1,2,1); showIm(im);
subplot(1,2,2); showIm(fftshift(abs(fft2(im))));
drawnow

% Rotating filter in time domain gives same rotation in freq domain
im = mkGaussian(sz,6) .* mkSine(sz,8,pi/3,1,0);
subplot(1,2,1); showIm(im);
subplot(1,2,2); showIm(fftshift(abs(fft2(im))));
drawnow

% Decreasing temporal window size increases uncertainty in freq domain
im = mkGaussian(sz,2) .* mkSine(sz,8);
subplot(1,2,1); showIm(im);
subplot(1,2,2); showIm(fftshift(abs(fft2(im))));
drawnow

