#
# CS488 -- Introduction to Computer Graphics
#
# setup.py
#
# This file takes the place of a Makefile for python extensions.
# It figures out how to compile your code into a module that can
# then be loaded into a running Python interpreter.  See the 
# documentation on 'distutils' in the online Python docs.  In
# almost all cases, it suffices to simply run 'python setup.py'
# to build your assignment.
#
# University of Waterloo Computer Graphics Lab / 2003
#

import sys
from distutils.core import setup, Extension

#
# Let's simplify things so that if you run setup.py with no arguments,
# it takes the default action of compiling the gr extension.
#
if len( sys.argv ) == 1:
	print '[assuming "build_ext --inplace"; use "help" for full options.]'
	sys.argv += [ 'build_ext', '--inplace' ]

std_include_dirs = []
std_library_dirs = []
std_libraries = [ 'GLU', 'GL' ]

#
# Hopefully this is sufficient to build C++ extensions on Linux.
#
if sys.platform == 'linux2':
	std_libraries += [ 'stdc++' ]

#
# Some hard-won changes that need to be made to compile this
# stuff under Mac OS X 10.2 (with fink installed).
# 
if sys.platform == 'darwin':
	std_include_dirs += ['/sw/include', '/usr/X11R6/include' ]
	std_library_dirs += ['/sw/lib', '/usr/X11R6/lib' ]
	std_libraries += [ 'stdc++' ] 

#
# An example of how to make things work with Visual Studio .NET.  YMMV.
# 
if sys.platform == 'win32':
	std_include_dirs += ['c:\\Program Files\\Microsoft Visual Studio .NET\\vc7\\PlatformSDK\\include\\gl' ]
	std_library_dirs += ['c:\\Program Files\\Microsoft Visual Studio .NET\\vc7\\PlatformSDK\\lib' ]
	std_libraries = [ 'GLU32', 'OpenGL32' ]

#
# Define the gr module.
#
gr_module = Extension( 'gr', 
	sources = [ 
		'algebra.cpp',
		'gr.cpp',
		'grmodule.cpp',
		'mesh.cpp',
		'readmesh.cpp' ],
	include_dirs = std_include_dirs,
	library_dirs = std_library_dirs,
	libraries = std_libraries
)

setup( name = 'gr', ext_modules = [ gr_module ] )
