#ifndef __MESH_H__
#define __MESH_H__

#include <iostream>
#include <vector>

#include "algebra.h"

struct Tri;

struct Vertex
{
	Vertex( const Point3D& pos )
		: pos_( pos )
		, fake_normal_()
	{}

	// The position of this vertex.
	Point3D 	pos_;

	// fake_normal_ is used while reading meshes to assign vertex normals 
	// to faces if necessary.
	Vector3D 	fake_normal_; 
};

struct Edge
{
	Vertex 		*v1_;	// The two vertices that bound this edge.
	Vertex 		*v2_;

	Tri 		*t1_;	// The triangle that has edge v1->v2
	size_t		e1_;	// The edge of that triangle that points here.

	Tri 		*t2_;	// The triangle that has edge v2->v1
	size_t		e2_;	// The edge of that triangle that points here.
};

struct Tri
{
	Tri();

	Vertex 		*vs_[3];	// Vertices
	Vector3D	ns_[3];		// Normal at each vertex
	Edge		*es_[3];	// Edge structures (edge 0 connects v0->v1, etc).

	Vector3D	normal_; 	// Normal for the face 
};

class TriMesh
{
public:
	TriMesh( std::istream& is );

	// Draw the model.
	void draw();

	// Set up some lighting for drawing the model nicely
	void initModelLighting();

	// Called when the viewport changes shape.
	void reshape();

private:

	std::vector<Vertex*>	verts_;
	std::vector<Edge*> 		edges_;
	std::vector<Tri*> 		tris_;

	std::vector<Edge*> 		creases_;
};

#endif // __MESH_H__
