#include <algorithm>
#include <iostream>
#include <iomanip>

#include <GL/gl.h>
#include <GL/glu.h>

#include "mesh.h"

Tri::Tri()
{
	for( size_t idx = 0; idx < 3; ++idx ) {
		vs_[ idx ] = NULL;
		es_[ idx ] = NULL;
	}
}

void TriMesh::initModelLighting()
{
	// Set up some default lighting and material properties.

    GLfloat f_color[] = { 0.6f, 0.6f, 0.6f, 1.0f };
    GLfloat f_specular[] = { 0.1f, 0.1f, 0.1f, 0.1f };
    GLfloat f_shininess[] = { 10.0f };
    GLfloat ambient_light[] = { 0.3f, 0.3f, 0.3f, 1.0f };
    GLfloat diffuse_light[] = { 1.0f, 1.0f, 1.0f, 1.0f };
    GLfloat light_position[] = { 0.0f, 1.0f, 10.0f, 0.0f };

	glMatrixMode( GL_MODELVIEW );
	glPushMatrix();
	glLoadIdentity();

    glLightfv( GL_LIGHT0, GL_POSITION, light_position );
    glLightModelfv( GL_LIGHT_MODEL_AMBIENT, ambient_light );
    glLightfv( GL_LIGHT0, GL_DIFFUSE, diffuse_light );
    glMaterialfv( GL_FRONT, GL_SPECULAR, f_specular );
    glMaterialfv( GL_FRONT, GL_SHININESS, f_shininess );
	glMaterialfv( GL_FRONT, GL_AMBIENT_AND_DIFFUSE, f_color );

	glEnable( GL_LIGHTING );
	glEnable( GL_LIGHT0 );
	glDisable( GL_COLOR_MATERIAL );

	glPopMatrix();
}

void TriMesh::draw()
{
	glClearColor( 0.8, 0.8, 1.0, 1.0 );
	glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

	initModelLighting();

	glEnable( GL_DEPTH_TEST );
	glShadeModel( GL_SMOOTH );
	glEnable( GL_CULL_FACE );
	glCullFace( GL_BACK );

	glBegin( GL_TRIANGLES );

	for( size_t idx = 0; idx < tris_.size(); ++idx ) {
		const Tri *t = tris_[ idx ];

		for( size_t v = 0; v < 3; ++v ) {
			const Point3D& p = t->vs_[ v ]->pos_;

			glNormal3d( t->ns_[v][0], t->ns_[v][1], t->ns_[v][2] );
			glVertex3d( p[0], p[1], p[2] );
		}
	}

	glEnd();
}

void TriMesh::reshape()
{
	// Called when the viewport changed shape (when the user
	// changes the size of the window).  In my implementation,
	// I maintain a pre-allocated array into which glReadPixels
	// places its result.  I use this call to delete the array
	// and rebuild it (with its new dimensions) next time I draw.
}
