//---------------------------------------------------------------------------
//
// CS488 -- Introduction to Computer Graphics
//
// gr.h/gr.cpp
//
// Code that implements the C back-end for this assignment.
//
// University of Waterloo Computer Graphics Lab / 2003
//
//---------------------------------------------------------------------------

#ifdef _WIN32
#include <windows.h>
#endif

#include <cmath>
#include <time.h>

#include <iostream>
#include <fstream>
#include <string>
#include <cstring>

#include <GL/gl.h>
#include <GL/glu.h>

#include "algebra.h"
#include "mesh.h"
#include "gr.h"

TriMesh *mesh = NULL;

void gr_load_model( const char *fname )
{
	std::ifstream ifs( fname );
	if( mesh ) {
		delete mesh;
	}
	mesh = new TriMesh( ifs );
}

void gr_draw_model()
{
	if( mesh ) {
		mesh->draw();
	}
}

void gr_do_reshape()
{
	if( mesh ) {
		mesh->reshape();
	}
}

// Here, I've set up a simple way for you to pass options and 
// values from your user interface down into C++.  You may want
// to add things to the user interface to set modes, set parameters,
// or turn features on or off.  You can do that by adding cases to
// these functions.

void gr_toggle_option( const char *opt )
{
/* EXAMPLE:
	if( !strcmp( opt, "frobnicate" ) ) {
		do_frobnicate = true;
	}
*/
}

void gr_set_option( const char *opt, double value )
{
/* EXAMPLE:
	if( !strcmp( opt, "offset_factor" ) ) {
		offset_factor = value;
	}
*/
}
