#
# CS798 -- Nonphotorealistic computer graphics
#
# a2.py
#
# This file contains the user interface for assignment 2.
#
# University of Waterloo Computer Graphics Lab / 2004
#

# Get some basic Python modules
#
from math import *
from Tkinter import *
import random
import sys
import string
import operator
import time

# Because of the way that the Togl widget was 'designed', we need to create
# a Tk root right now before importing any of the OpenGL bindings.  Yeesh.
#
root = Tk()
root.title( 'CS798 Assignment 2' )
root.minsize( 200, 200 )
root.maxsize( 1000, 1000 )

# Now we can bring in OpenGL-related stuff.
#
from OpenGL.Tk import *

from OpenGL.GL import *
from OpenGL.GLU import *

# Bring in the Python Imaging Library, an extremely powerful and
# easy-to-use tool for manipulating images (see the 'save' method
# below).
# import Image

# Import our new gr functions.
import gr

class Callback:
	def __init__( self, func, *args, **kwargs ):
		self.func = func
		self.args = args
		self.kwargs = kwargs

	def __call__( self, *whatever ):
		return apply( self.func, self.args+whatever, self.kwargs )

class Discard:
	def __init__( self, func, *args, **kwargs ):
		self.func = func
		self.args = args
		self.kwargs = kwargs

	def __call__( self, *whatever ):
		return apply( self.func, self.args, self.kwargs )

class GrCanvas( Togl ):
	# Construct a new GrCanvas
	def __init__( self, master, **kw ):
		Togl.__init__( self, master, kw )

		self.bind( '<Map>', self.initialize )
		self.bind( '<Expose>', self.render )
		self.bind( '<Configure>', self.reshape )
		
		self.bind( '<Button-1>', Callback( self.buttonPress, 1 ) )
		self.bind( '<ButtonRelease-1>', Callback( self.buttonRelease, 1 ) )
		self.bind( '<Button-2>', Callback( self.buttonPress, 2 ) )
		self.bind( '<ButtonRelease-2>', Callback( self.buttonRelease, 2 ) )
		self.bind( '<Button-3>', Callback( self.buttonPress, 3 ) )
		self.bind( '<ButtonRelease-3>', Callback( self.buttonRelease, 3 ) )

		self.bind( '<Motion>', self.mouseMotion )

		self.bind( '<Enter>', self.doEnter )

		# Set a flag to indicate whether gr.initialize was called.
		self.did_init = 0

		self.buttons = [0,0,0]

		self.last = None

		self.ftimes = [1.0]

		self.R = gr.identity()
		self.translation = (0.0,0.0,-20.0)

	def doEnter( self, *args ):
		self.focus_set()

	def initialize( self, event=None ):
		# This makes the OpenGL context associated with this window
		# the current one, so that all OpenGL calls will go to the
		# right place.
		self.makecurrent()

		self.did_init = 1

		# It turns out that when you open the window, it <Map>s after
		# it <Expose>s.  So we'll ask explicitly for a first rendering
		# call here.
		#
		self.render()

	def reshape( self, event=None ):
		gr.do_reshape()
		if self.did_init:
			self.render( event )

	def render( self, event=None ):
		# Let's not render unless initialize has been called.
		if self.did_init:
			width = self.winfo_width()
			height = self.winfo_height()
			t = time.time()

			self.makecurrent()

			glMatrixMode( GL_PROJECTION )
			glLoadIdentity()
			glViewport( 0, 0, width, height )
			gluPerspective( 40.0, float(width)/float(height), 0.1, 1000.0 )

			glMatrixMode( GL_MODELVIEW )
			glLoadIdentity()
			apply( glTranslated, self.translation )
			glMultMatrixd( tuple( gr.transpose( self.R ) ) )

			gr.draw_model()

			glFlush()

			self.swapbuffers()

			t = time.time() - t
			self.ftimes.append( t )
			if len( self.ftimes ) > 10:
				self.ftimes = self.ftimes[1:]

			ttime = (reduce( operator.add, self.ftimes ) /
				float( len( self.ftimes ) ) )
			self.status[ 'text' ] = ( 'FPS = %.3f' % (1.0 / ttime) )

	def buttonPress( self, num, event ):
		if (num < 1) or (num > 3):
			return

		self.last = (float(event.x),float(event.y))

		if self.buttons == [0,0,0]:
			self.buttons[ num - 1 ] = 1

	def buttonRelease( self, num, *args ):
		if (num < 1) or (num > 3):
			return

		self.buttons[ num - 1 ] = 0

	# I'm sorry for being a bit of a jerk about this, but I'm going
	# to leave this function mostly unwritten.  The problem is that
	# it's roughly equivalent to part of assignment 3 in the undergraduate
	# graphics course (488).  I can't simply put the code here because 
	# some 798 students are also in 488.  In any case, if I put this
	# source distribution up on the web, 488 students would easily be
	# able to download it.
	#
	# So my suggestion is for you to dig up your assignment 3 code
	# from 488 and insert it here.  If you're taking 488 now, you'll
	# kill two birds with one stone by writing the code here.  If
	# this is your first time dealing with trackball rotation, consider
	# looking in the instructions for 488 assignment 3.  Doug Zongker
	# also has an example program featuring trackball rotation here:
	#
	# 	http://soggy.sourceforge.net/
	#
	def mouseMotion( self, event ):
		if self.buttons == [0,0,0]:
			return

		lastx, lasty = self.last
		x, y = float( event.x ), float( event.y )
		self.last = (x,y)

		if self.buttons[0]:
			# Map x and y motion of the mouse to x and y motion of 
			# the camera
			pass

		elif self.buttons[1]:
			# Map y motion of the mouse to z motion of the camera
			pass

		elif self.buttons[2]:
			# Do a trackball rotation of the model
			pass

		self.render()

	def resetPosition( self, *args ):
		self.translation = (0.0,0.0,-20.0)
		self.render()

	def resetOrientation( self, *args ):
		self.R = gr.identity()
		self.render()

	def resetAll( self, *args ):
		self.translation = (0.0,0.0,-20.0)
		self.R = gr.identity()
		self.render()

	def quit( self, *args ):
		self.destroy()
		self.master.quit()

def add_menu_cmd( canvas, menu, name, cmd, keys ):
	menu.add_command( label=name, command=cmd )
	for k in keys:
		canvas.bind( k, Callback( cmd ) )

#
# Build the main application interface.
#
def createInterface( theroot ):
	# Put the OpenGL widget inside a pretty sunken frame.
	frame = Frame( theroot, bd='2m', relief=SUNKEN )
	frame.pack( expand=YES, fill=BOTH, padx='2m', pady='2m' )

	canvas = GrCanvas( frame, rgba=1, depth=1, depthsize=8, double=1, 
		width=512, height=512 )
	canvas.pack( expand=YES, fill=BOTH, padx=2, pady=2 )

	status = Label( frame, justify=LEFT )
	status.pack( expand=YES, fill=X )
	canvas.status = status

	# Set up a dummy slider, just to show how it's done.  When you're
	# about to render, you can get() the current value of the slider
	# and pass it to your C++ code using gr.set_option.
	canvas.sc1 = Scale( frame, from_ = 0.0, to = 100.0, resolution = 0.1,
	 	orient=HORIZONTAL, command = canvas.render )
	canvas.sc1.pack( expand=YES, fill=X )
	canvas.sc1.set( 10.0 )

	menubar = Menu( theroot )

	file_menu = Menu( menubar )

	for menu_entry in [	
			( 'Reset Position (I)', canvas.resetPosition, 'iI' ),
			( 'Reset Orientation (O)', canvas.resetOrientation, 'oO' ),
			( 'Reset All (A)', canvas.resetAll, 'aA' ), 
			None,
			( 'Quit (Q)', canvas.quit, 'qQ' ) ]:
		if menu_entry:
			name, cmd, keys = menu_entry
			add_menu_cmd( canvas, file_menu, name, cmd, keys )
		else:
			file_menu.add_separator()

	menubar.add_cascade( label='File', menu=file_menu )

	theroot.config( menu=menubar )

	return canvas

#
# Simple interface that loads in a model specified as the first
# argument on the command line.
#
if __name__ == '__main__':
	# Build a GUI.  'root' is defined near the top of this file.
	canvas = createInterface( root )
	gr.load_model( sys.argv[1] )

	# Start the show
	root.mainloop()
