#include <linbox/linbox-config.h>
#include <linbox/matrix/sparse-matrix.h>
#include <linbox/polynomial/dense-polynomial.h>
#include <linbox/solutions/minpoly.h>

using namespace LinBox;

template <class Field, class Polynomial>
void printPolynomial(const Field &F, const Polynomial &p)
{
	for (int i = (int)p.size() - 1; i >= 0; i--) {
		F.write(std::cout, p[(size_t)i]);
		if (i > 0)
			std::cout << "x^" << i << " + ";
	}
	std::cout << std::endl;
}

int main(int argc, char **argv)
{
	std::ifstream in(argv[1]);

	Givaro::ZRing<Integer> Z;
	SparseMatrix<Givaro::ZRing<Integer> > A(Z);
	DensePolynomial<Givaro::ZRing<Integer> > p(Z);
	Method::Blackbox B;

	A.read(in);
	minpoly(p, A, B);
	printPolynomial(Z, p);

	return 0;
}
