#!/usr/bin/env python3

import collections
import fileinput


entries = collections.defaultdict(lambda: collections.defaultdict(int))
for line in fileinput.input():
    if 'START' in line or 'FINAL' in line:
        continue
    p, _, q = line.strip().split(" ")
    entries[int(p)][int(q)] += 1

print("{0} {0} M".format(len(entries)))
for p, row in entries.items():
    for q, count in row.items():
        print("{} {} {}".format(p + 1, q + 1, count))
print("0 0 0")
