package Token;
import java.util.Stack;

import Automata.NumberSystem;
import Main.Expression;


public class NumberLiteral extends Token {
	int value;
	NumberSystem base;
	public NumberLiteral(int position,int value,NumberSystem base){
		setPositionInPredicate(position);
		setArity(0);
		this.value = value;
		this.base = base;
	}
	public String toString(){
		return Integer.toString(value);
	}
	public void act(Stack<Expression> S) throws Exception{
		S.push(new Expression(Integer.toString(value), value,base));
	}
}
